/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.internal.org.bouncycastle.crypto.modes.gcm;

import com.auth0.jwt.internal.org.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import com.auth0.jwt.internal.org.bouncycastle.crypto.modes.gcm.GCMUtil;
import com.auth0.jwt.internal.org.bouncycastle.util.Arrays;

public class BasicGCMExponentiator
implements GCMExponentiator {
    private int[] x;

    public void init(byte[] byArray) {
        this.x = GCMUtil.asInts(byArray);
    }

    public void exponentiateX(long l, byte[] byArray) {
        int[] nArray = GCMUtil.oneAsInts();
        if (l > 0L) {
            int[] nArray2 = Arrays.clone(this.x);
            do {
                if ((l & 1L) != 0L) {
                    GCMUtil.multiply(nArray, nArray2);
                }
                GCMUtil.multiply(nArray2, nArray2);
            } while ((l >>>= 1) > 0L);
        }
        GCMUtil.asBytes(nArray, byArray);
    }
}

